/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.thema;

import data.structures.classification.Operation;
import data.structures.thema.ThemaGraph;
import data.structures.corpus.CorpusGraph;

public class Experiences {
    private final static Experience XP1 = new Experience();
    private final static Experience XP2 = new Experience();
    private final static Experience XP3 = new Experience();
    private final static Experience XP4 = new Experience();
    private final static Experience XP5 = new Experience();
    private final static Experience XP5b = new Experience();
    private final static Experience XP5c = new Experience();
    private final static Experience XP6 = new Experience();
    private final static Experience XP7 = new Experience();
    private final static Experience XP8 = new Experience();
    private final static Experience XP9 = new Experience();
    private final static Experience XP10 = new Experience();
    private final static Experience XP11 = new Experience();
    private final static Experience XP12 = new Experience();
    private final static Experience XP13 = new Experience();
    private final static Experience XP14 = new Experience();
    private final static Experience XP15 = new Experience();
    private final static Experience XP16 = new Experience();
    private final static Experience[] liste = new Experience[]{
        XP1, XP2, XP3, XP4, XP5, XP5b, XP5c, XP6, XP7, XP8, XP9, XP10, XP11, XP12, XP13, XP14, XP15, XP16};

    static{
        XP1.setTitre("Expérience I - Classification basique");
        XP1.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base. <br>" +
                "Enrichissement d'articles de base. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP1.setEnrichThemaBase(true);
        XP1.setEnrichThemaSpe(false);
        XP1.setEnrichThemaGen(false);
        XP1.setEnrichThemaCat(false);
        XP1.setEnrichThemaSem(false);
        XP1.setEnrichArticleBase(true);
        XP1.setEnrichArticleGen(false);
        XP1.setEnrichArticleCat(false);
        XP1.setEnrichArticleSem(false);
        XP1.annulePoidsCategories();
        XP1.setPoidsCategorie("NOM", 1.0);
        XP1.setPoidsCategorie("NAM", 1.0);
        XP1.setNormalisationTaille(true);
        XP2.setTitre("Expérience II - Classification avec spécialisation");
        XP2.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base et par spécialisation. <br>" +
                "Enrichissement d'articles de base. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP2.setEnrichThemaBase(true);
        XP2.setEnrichThemaSpe(true);
        XP2.setEnrichThemaGen(false);
        XP2.setEnrichThemaCat(false);
        XP2.setEnrichThemaSem(false);
        XP2.setEnrichArticleBase(true);
        XP2.setEnrichArticleGen(false);
        XP2.setEnrichArticleCat(false);
        XP2.setEnrichArticleSem(false);
        XP2.annulePoidsCategories();
        XP2.setPoidsCategorie("NOM", 1.0);
        XP2.setPoidsCategorie("NAM", 1.0);
        XP2.setNormalisationTaille(true);
        XP3.setTitre("Expérience III - Classification avec généralisation");
        XP3.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base et par généralisation. <br>" +
                "Enrichissement d'articles de base et par généralisation. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP3.setEnrichThemaBase(true);
        XP3.setEnrichThemaSpe(false);
        XP3.setEnrichThemaGen(true);
        XP3.setEnrichThemaCat(false);
        XP3.setEnrichThemaSem(false);
        XP3.setEnrichArticleBase(true);
        XP3.setEnrichArticleGen(true);
        XP3.setEnrichArticleCat(false);
        XP3.setEnrichArticleSem(false);
        XP3.annulePoidsCategories();
        XP3.setPoidsCategorie("NOM", 1.0);
        XP3.setPoidsCategorie("NAM", 1.0);
        XP3.setNormalisationTaille(true);
        XP4.setTitre("Expérience IV - Classification avec catégories");
        XP4.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base et par catégories. <br>" +
                "Enrichissement d'articles de base et par catégories. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP4.setEnrichThemaBase(true);
        XP4.setEnrichThemaSpe(false);
        XP4.setEnrichThemaGen(false);
        XP4.setEnrichThemaCat(true);
        XP4.setEnrichThemaSem(false);
        XP4.setEnrichArticleBase(true);
        XP4.setEnrichArticleGen(false);
        XP4.setEnrichArticleCat(true);
        XP4.setEnrichArticleSem(false);
        XP4.annulePoidsCategories();
        XP4.setPoidsCategorie("NOM", 1.0);
        XP4.setPoidsCategorie("NAM", 1.0);
        XP4.setNormalisationTaille(true);
        XP5.setTitre("Expérience V - Classification avec champ sémantique");
        XP5.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base et par champ sémantique. <br>" +
                "Enrichissement d'articles de base et par champ sémantique. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP5.setEnrichThemaBase(true);
        XP5.setEnrichThemaSpe(false);
        XP5.setEnrichThemaGen(false);
        XP5.setEnrichThemaCat(false);
        XP5.setEnrichThemaSem(true);
        XP5.setEnrichArticleBase(true);
        XP5.setEnrichArticleGen(false);
        XP5.setEnrichArticleCat(false);
        XP5.setEnrichArticleSem(true);
        XP5.annulePoidsCategories();
        XP5.setPoidsCategorie("NOM", 1.0);
        XP5.setPoidsCategorie("NAM", 1.0);
        XP5.setNormalisationTaille(true);
        XP5b.setTitre("Expérience Vb - Classification avec champ sémantique");
        XP5b.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base et par champ sémantique. <br>" +
                "Enrichissement d'articles de base et par champ sémantique. <br> " +
                "Poids des opérations : <br><ul><li>Accès titre : 1.0</li>" +
                "<li>Accès description : 0,75</li><li>Accès au champ sémantique : 0.5</li></ul>" +
                "<br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP5b.setEnrichThemaBase(true);
        XP5b.setEnrichThemaSpe(false);
        XP5b.setEnrichThemaGen(false);
        XP5b.setEnrichThemaCat(false);
        XP5b.setEnrichThemaSem(true);
        XP5b.setEnrichArticleBase(true);
        XP5b.setEnrichArticleGen(false);
        XP5b.setEnrichArticleCat(false);
        XP5b.setEnrichArticleSem(true);
        XP5b.annulePoidsCategories();
        XP5b.setPoidsCategorie("NOM", 1.0);
        XP5b.setPoidsCategorie("NAM", 1.0);
        XP5b.setNormalisationTaille(true);
        XP5b.setPoidsOrigine(Operation.ACCES_TITRE, 1.0);
        XP5b.setPoidsOrigine(Operation.ACCES_DESC, 0.75);
        XP5b.setPoidsOrigine(Operation.CHAMP_SEMANTIQUE, 0.5);
        XP5c.setTitre("Expérience Vc - Classification avec champ sémantique");
        XP5c.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base et par champ sémantique. <br>" +
                "Enrichissement d'articles de base et par champ sémantique. <br> " +
                "Poids des opérations : <br><ul><li>Accès titre : 1.0</li>" +
                "<li>Accès description : 0,5</li><li>Accès au champ sémantique : 0.25</li></ul>" +
                "<br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP5c.setEnrichThemaBase(true);
        XP5c.setEnrichThemaSpe(false);
        XP5c.setEnrichThemaGen(false);
        XP5c.setEnrichThemaCat(false);
        XP5c.setEnrichThemaSem(true);
        XP5c.setEnrichArticleBase(true);
        XP5c.setEnrichArticleGen(false);
        XP5c.setEnrichArticleCat(false);
        XP5c.setEnrichArticleSem(true);
        XP5c.annulePoidsCategories();
        XP5c.setPoidsCategorie("NOM", 1.0);
        XP5c.setPoidsCategorie("NAM", 1.0);
        XP5c.setNormalisationTaille(true);
        XP5b.setPoidsOrigine(Operation.ACCES_TITRE, 1.0);
        XP5b.setPoidsOrigine(Operation.ACCES_DESC, 0.5);
        XP5b.setPoidsOrigine(Operation.CHAMP_SEMANTIQUE, 0.25);
        XP6.setTitre("Expérience VI - Classification avec spécialisation et généralisation");
        XP6.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par spécialisation et par généralisation. <br>" +
                "Enrichissement d'articles de base et par généralisation. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP6.setEnrichThemaBase(true);
        XP6.setEnrichThemaSpe(true);
        XP6.setEnrichThemaGen(true);
        XP6.setEnrichThemaCat(false);
        XP6.setEnrichThemaSem(false);
        XP6.setEnrichArticleBase(true);
        XP6.setEnrichArticleGen(true);
        XP6.setEnrichArticleCat(false);
        XP6.setEnrichArticleSem(false);
        XP6.annulePoidsCategories();
        XP6.setPoidsCategorie("NOM", 1.0);
        XP6.setPoidsCategorie("NAM", 1.0);
        XP6.setNormalisationTaille(true);
        XP7.setTitre("Expérience VII - Classification avec spécialisation et catégorisation");
        XP7.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par spécialisation et par catégorisation. <br>" +
                "Enrichissement d'articles de base et par catégorisation. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP7.setEnrichThemaBase(true);
        XP7.setEnrichThemaSpe(true);
        XP7.setEnrichThemaGen(false);
        XP7.setEnrichThemaCat(true);
        XP7.setEnrichThemaSem(false);
        XP7.setEnrichArticleBase(true);
        XP7.setEnrichArticleGen(false);
        XP7.setEnrichArticleCat(true);
        XP7.setEnrichArticleSem(false);
        XP7.annulePoidsCategories();
        XP7.setPoidsCategorie("NOM", 1.0);
        XP7.setPoidsCategorie("NAM", 1.0);
        XP7.setNormalisationTaille(true);
        XP8.setTitre("Expérience VIII - Classification avec spécialisation et champ sémantique");
        XP8.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par spécialisation et par champ sémantique. <br>" +
                "Enrichissement d'articles de base et par champ sémantique. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP8.setEnrichThemaBase(true);
        XP8.setEnrichThemaSpe(true);
        XP8.setEnrichThemaGen(false);
        XP8.setEnrichThemaCat(false);
        XP8.setEnrichThemaSem(true);
        XP8.setEnrichArticleBase(true);
        XP8.setEnrichArticleGen(false);
        XP8.setEnrichArticleCat(false);
        XP8.setEnrichArticleSem(true);
        XP8.annulePoidsCategories();
        XP8.setPoidsCategorie("NOM", 1.0);
        XP8.setPoidsCategorie("NAM", 1.0);
        XP8.setNormalisationTaille(true);
        XP9.setTitre("Expérience IX - Classification avec généralisation et catégorisation");
        XP9.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par généralisation et par catégorisation. <br>" +
                "Enrichissement d'articles de base, par généralisation et par catégorisation. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP9.setEnrichThemaBase(true);
        XP9.setEnrichThemaSpe(false);
        XP9.setEnrichThemaGen(true);
        XP9.setEnrichThemaCat(true);
        XP9.setEnrichThemaSem(false);
        XP9.setEnrichArticleBase(true);
        XP9.setEnrichArticleGen(true);
        XP9.setEnrichArticleCat(true);
        XP9.setEnrichArticleSem(false);
        XP9.annulePoidsCategories();
        XP9.setPoidsCategorie("NOM", 1.0);
        XP9.setPoidsCategorie("NAM", 1.0);
        XP9.setNormalisationTaille(true);
        XP10.setTitre("Expérience X - Classification avec généralisation et champ sémantique");
        XP10.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par généralisation et par champ sémantique. <br>" +
                "Enrichissement d'articles de base, par généralisation et par champ sémantique. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP10.setEnrichThemaBase(true);
        XP10.setEnrichThemaSpe(false);
        XP10.setEnrichThemaGen(true);
        XP10.setEnrichThemaCat(false);
        XP10.setEnrichThemaSem(true);
        XP10.setEnrichArticleBase(true);
        XP10.setEnrichArticleGen(true);
        XP10.setEnrichArticleCat(false);
        XP10.setEnrichArticleSem(true);
        XP10.annulePoidsCategories();
        XP10.setPoidsCategorie("NOM", 1.0);
        XP10.setPoidsCategorie("NAM", 1.0);
        XP10.setNormalisationTaille(true);
        XP11.setTitre("Expérience XI - Classification avec catégorisation et champ sémantique");
        XP11.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par catégorisation et par champ sémantique. <br>" +
                "Enrichissement d'articles de base, par catégorisation et par champ sémantique. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP11.setEnrichThemaBase(true);
        XP11.setEnrichThemaSpe(false);
        XP11.setEnrichThemaGen(false);
        XP11.setEnrichThemaCat(true);
        XP11.setEnrichThemaSem(true);
        XP11.setEnrichArticleBase(true);
        XP11.setEnrichArticleGen(false);
        XP11.setEnrichArticleCat(true);
        XP11.setEnrichArticleSem(true);
        XP11.annulePoidsCategories();
        XP11.setPoidsCategorie("NOM", 1.0);
        XP11.setPoidsCategorie("NAM", 1.0);
        XP11.setNormalisationTaille(true);
        XP12.setTitre("Expérience XII - Classification avec spécialisation, généralisation et catégorisation");
        XP12.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par spécialisation, par généralisation et par catégorisation. <br>" +
                "Enrichissement d'articles de base, par généralisation et par catégorisation. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP12.setEnrichThemaBase(true);
        XP12.setEnrichThemaSpe(true);
        XP12.setEnrichThemaGen(true);
        XP12.setEnrichThemaCat(true);
        XP12.setEnrichThemaSem(false);
        XP12.setEnrichArticleBase(true);
        XP12.setEnrichArticleGen(true);
        XP12.setEnrichArticleCat(true);
        XP12.setEnrichArticleSem(false);
        XP12.annulePoidsCategories();
        XP12.setPoidsCategorie("NOM", 1.0);
        XP12.setPoidsCategorie("NAM", 1.0);
        XP12.setNormalisationTaille(true);
        XP13.setTitre("Expérience XIII - Classification avec spécialisation, généralisation et champ sémantique");
        XP13.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par spécialisation, par généralisation et par champ sémantique. <br>" +
                "Enrichissement d'articles de base, par généralisation et par champ sémantique. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP13.setEnrichThemaBase(true);
        XP13.setEnrichThemaSpe(true);
        XP13.setEnrichThemaGen(true);
        XP13.setEnrichThemaCat(false);
        XP13.setEnrichThemaSem(true);
        XP13.setEnrichArticleBase(true);
        XP13.setEnrichArticleGen(true);
        XP13.setEnrichArticleCat(false);
        XP13.setEnrichArticleSem(true);
        XP13.annulePoidsCategories();
        XP13.setPoidsCategorie("NOM", 1.0);
        XP13.setPoidsCategorie("NAM", 1.0);
        XP13.setNormalisationTaille(true);
        XP14.setTitre("Expérience XIV - Classification avec spécialisation, catégorisation et champ sémantique");
        XP14.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par spécialisation, par catégorisation et par champ sémantique. <br>" +
                "Enrichissement d'articles de base, par catégorisation et par champ sémantique. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP14.setEnrichThemaBase(true);
        XP14.setEnrichThemaSpe(true);
        XP14.setEnrichThemaGen(false);
        XP14.setEnrichThemaCat(true);
        XP14.setEnrichThemaSem(true);
        XP14.setEnrichArticleBase(true);
        XP14.setEnrichArticleGen(false);
        XP14.setEnrichArticleCat(true);
        XP14.setEnrichArticleSem(true);
        XP14.annulePoidsCategories();
        XP14.setPoidsCategorie("NOM", 1.0);
        XP14.setPoidsCategorie("NAM", 1.0);
        XP14.setNormalisationTaille(true);
        XP15.setTitre("Expérience XIV - Classification avec généralisation, catégorisation et champ sémantique");
        XP15.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par spécialisation, par catégorisation et par champ sémantique. <br>" +
                "Enrichissement d'articles de base, par catégorisation et par champ sémantique. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP15.setEnrichThemaBase(true);
        XP15.setEnrichThemaSpe(false);
        XP15.setEnrichThemaGen(true);
        XP15.setEnrichThemaCat(true);
        XP15.setEnrichThemaSem(true);
        XP15.setEnrichArticleBase(true);
        XP15.setEnrichArticleGen(true);
        XP15.setEnrichArticleCat(true);
        XP15.setEnrichArticleSem(true);
        XP15.annulePoidsCategories();
        XP15.setPoidsCategorie("NOM", 1.0);
        XP15.setPoidsCategorie("NAM", 1.0);
        XP15.setNormalisationTaille(true);
        XP16.setTitre("Expérience XV - Classification avec spécialisation, généralisation, catégorisation et champ sémantique");
        XP16.setDesc("<html><i>(Cf. Protocole sur le Wiki)</i><br>" +
                "Enrichissement thématique de base, par spécialisation, par généralisation, par catégorisation et par champ sémantique. <br>" +
                "Enrichissement d'articles de base, par généralisation, par catégorisation et par champ sémantique. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul. <br>" +
                "Mono-classification.");
        XP16.setEnrichThemaBase(true);
        XP16.setEnrichThemaSpe(true);
        XP16.setEnrichThemaGen(true);
        XP16.setEnrichThemaCat(true);
        XP16.setEnrichThemaSem(true);
        XP16.setEnrichArticleBase(true);
        XP16.setEnrichArticleGen(true);
        XP16.setEnrichArticleCat(true);
        XP16.setEnrichArticleSem(true);
        XP16.annulePoidsCategories();
        XP16.setPoidsCategorie("NOM", 1.0);
        XP16.setPoidsCategorie("NAM", 1.0);
        XP16.setNormalisationTaille(true);
    }

    public static Experience[] getExperiences(){
        return liste;
    }

    public static void setCorpus(CorpusGraph corpus){
        for(int i=0; i<liste.length; i++){
            liste[i].setCorpus(corpus);
        }
    }

    public static void setThemas(ThemaGraph themas){
        for(int i=0; i<liste.length; i++){
            liste[i].setThemas(themas);
        }
    }

    public static void setBase(data.base.Database base){
        for(int i=0; i<liste.length; i++){
            liste[i].setBase(base);
        }
    }
}
